/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PortalSize {
    private final World world;
    private final EnumFacing.Axis axis;
    private final EnumFacing rightDir;
    private final EnumFacing leftDir;
    private int portalBlockCount;
    private BlockPos bottomLeft;
    private int height;
    private int width;

    public PortalSize(World world, BlockPos pos, EnumFacing.Axis axis) {
        this.world = world;
        this.axis = axis;
        if (axis == EnumFacing.Axis.X) {
            this.leftDir = EnumFacing.EAST;
            this.rightDir = EnumFacing.WEST;
        } else {
            this.leftDir = EnumFacing.NORTH;
            this.rightDir = EnumFacing.SOUTH;
        }
        BlockPos blockpos = pos;
        while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            pos = pos.func_177977_b();
        }
        int distanceToEdge = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
        if (distanceToEdge >= 0) {
            this.bottomLeft = pos.func_177967_a(this.leftDir, distanceToEdge);
            this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    protected int getDistanceUntilEdge(BlockPos pos, EnumFacing facing) {
        BlockPos offsetPos;
        int distance;
        for (distance = 0; distance < 22 && this.isEmptyBlock(this.world.func_180495_p(offsetPos = pos.func_177967_a(facing, distance)).func_177230_c()) && this.world.func_180495_p(offsetPos.func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian; ++distance) {
        }
        Block block = this.world.func_180495_p(pos.func_177967_a(facing, distance)).func_177230_c();
        return block == SCContent.reinforcedObsidian ? distance : 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos pos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                Block block = this.world.func_180495_p(pos).func_177230_c();
                if (!this.isEmptyBlock(block)) break block0;
                if (block == Blocks.field_150427_aO) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (block = this.world.func_180495_p(pos.func_177972_a(this.leftDir)).func_177230_c()) != SCContent.reinforcedObsidian : i == this.width - 1 && (block = this.world.func_180495_p(pos.func_177972_a(this.rightDir)).func_177230_c()) != SCContent.reinforcedObsidian) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == SCContent.reinforcedObsidian) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    protected boolean isEmptyBlock(Block block) {
        return block.func_149688_o(block.func_176223_P()) == Material.field_151579_a || block == Blocks.field_150480_ab || block == Blocks.field_150427_aO;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos pos = this.bottomLeft.func_177967_a(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.world.func_180501_a(pos.func_177981_b(j), Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 18);
            }
        }
    }

    public int getPortalBlockCount() {
        return this.portalBlockCount;
    }
}

